<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegistrationVoucherMail extends Mailable
{
    use Queueable, SerializesModels;

    public string $voucherCode;
    public ?string $recipientName;

    public function __construct(string $voucherCode, ?string $recipientName = null)
    {
        $this->voucherCode = $voucherCode;
        $this->recipientName = $recipientName;
    }

    public function build()
    {
        return $this->subject('Your Maybelline Voucher Code')
            ->view('mail') // using your mail.blade.php
            ->with([
                'voucherCode'  => $this->voucherCode,
                // fallback so we don't change design
                'recipientName'=> $this->recipientName ?: 'Customer',
            ]);
    }
}
