<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Maybelline Registration</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet" />

  <link href="{{ asset('assets/css/thanku.css') }}" rel="stylesheet" type="text/css">
</head>
<body>

<div class="container text-center p-0">

  <div class="form-container">
    <!-- Logo Section -->
    <div class="logo">
      <img src="{{ asset('assets/img/logo.png') }}" alt="Maybelline Logo" class="img-fluid">
    </div>

    <!-- Banner Section -->
    <div class="banner">
      <img src="{{ asset('assets/img/Asset-2ldpi.jpg') }}" alt="Maybelline Banner" class="img-fluid">
    </div>

    <!-- COPY PANEL -->
    <section class="copy">
      <h4 class="eyebrow">Hello from Maybelline New York!</h4>
      <h5 class="lead-strong">Thank you for your recent ₹10,000 Maybelline purchase!</h5>
      <h4 class="eyebrow">
        We’re thrilled to show our appreciation this festive season <br>
        with a special gift just for you.
      </h4>
      <h5 class="eyebrowg">
        Enjoy a <span class="lead-strong">₹2,500 voucher for luxurious salon services</span><br>
        at a Looks Salon in your city!
      </h5>

      <!-- Looks Salon wordmark -->
      <img src="{{ asset('assets/img/Asset 2ldpi.png') }}" class="img-fluid looks-logo mt-1" alt="Looks Salon">

      <h4 class="redeem mt-2">Redeem your voucher by <span class="amount">31<sup>st</sup> March, 2026</span></h4>
      <h4 class="text-uppercase mt-2">Enjoy your service with this code</h4>

      <!-- Inject real voucher code -->
      <div class="code-wrap">VOUCHER CODE: {{ $voucher ?? '—' }}</div>

      <h4 class="tagline mt-2">
        Maybe it’s your festive glam, <b>Maybe it’s Maybelline.</b>
      </h4>
    </section>

    <!-- Footer strip -->
    <div class="footer">
      <img src="{{ asset('assets/img/Asset 3ldpi.png') }}" class="img-fluid" alt="Footer Artwork">
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
