<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RegistrationController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

Route::get('/', [RegistrationController::class, 'index'])->name('register.index');
Route::post('/register', [RegistrationController::class, 'store'])->name('register.store');
Route::post('/register/validate-field', [RegistrationController::class, 'validateField'])->name('register.validate'); // AJAX
Route::get('/thanks', [RegistrationController::class, 'thanks'])->name('register.thanks');
Route::get('/clear-cache', function () {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    Artisan::call('optimize:clear');
    return 'Caches cleared';
});

Route::get('/mail', function () {
    return view('mail');
});
Route::get('/_smtp_test', function () {
    try {
        Mail::raw('SMTP test '.now(), function ($m) {
            $m->from('support@incentivesolutions.in', 'Incentive Solutions');
            $m->to('phpdev1@incentivesolutions.co.in')->subject('SMTP test cr');
        });
        return 'OKk';
    } catch (\Throwable $e) {
        return nl2br(e($e->getMessage()));
    }
});